@extends('layouts.master')
@section('content')
    <div class="az-content-breadcrumb">
        <span>Products</span>
    </div>
    <h2 class="az-content-title" style="display: inline">
        Products List
        {{-- <span>
            <a href="{{ route('good_receipts.create') }}" class="btn btn-az-primary" style="float: right">
                <i class="fa-solid fa-plus"></i> Add Products </a>
        </span> --}}
    </h2>

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12">
            <div class="card card-body pd-20">
                <div>
                    <table id="example2" class="table table-striped table-hover table-bordered">
                        <thead class="thead-dark">
                            <tr>
                                <th class="wd-10p">#</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-10p">P. No</th>
                                <th class="wd-10p">Truck No</th>
                                <th class="wd-10p">Products Name</th>
                                <th class="wd-10p">Marka</th>
                                <th class="wd-10p">Overall Bori</th>
                                <th class="wd-10p">Remaining Bori</th>
                                {{-- <th class="wd-10p">Sold</th> --}}
                                <th class="wd-10p">Weight</th>
                                <th class="wd-10p">Rate</th>
                                <th class="wd-10p">Builty No</th>
                                <th class="none">Supplier</th>
                                <th class="none">Remarks</th>
                                <th class="none">Created By</th>
                                {{-- <th>Actions</th> --}}
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $counter = 1;
                            @endphp
                            @foreach ($good_receipts_truck as $key => $truck)
                                @foreach ($truck->goodReceipts as $receipt)
                                    @foreach ($receipt->goodReceiptDetails as $detail)
                                        @php
                                            // Initialize bori_remaining with the original bori quantity
                                            $bori_remaining = $detail->bori;

                                            // Check if there's a matching sale item to subtract bori
                                            foreach ($sales as $sale) {
                                                // {{ dd($sale) }}
                                                foreach ($sale->salesItemsDetails as $sitem) {
                                                    if ($detail->goods_name == $sitem->items_name) {
                                                        $bori_remaining -= $sitem->bori;
                                                    }
                                                }
                                            }
                                        @endphp

                                        <tr>
                                            <td>{{ $counter }}</td>
                                            <td>{{ $receipt->date }}</td>
                                            <td>{{ $receipt->p_no }}</td>
                                            <td>{{ $truck->truck_no }}</td>
                                            <td>{{ $detail->goods_name }}</td>

                                            <td>{{ $detail->marka }}</td>
                                            <td>{{ $detail->bori }}</td>
                                            <td>{{ $bori_remaining }}</td> <!-- Display the remaining bori -->
                                            {{-- @if (isset($detail->goods_name) && isset($sitem->items_name) && $detail->goods_name == $sitem->items_name)
                                                <td>{{ $sitem->bori }}</td>
                                            @else
                                                <td>0</td>
                                            @endif --}}
                                            <td>{{ $detail->weight }}</td>
                                            <td>{{ $detail->rate }}</td>
                                            <td>{{ $receipt->builty_no }}</td>
                                            <td>{{ $receipt->supplier->supplier_name ?? 'N/A' }}</td>
                                            <td>{{ $detail->remarks }}</td>
                                            @php
                                                $user = \App\User::find($receipt->created_by);
                                            @endphp
                                            <td>{{ $user ? $user->name : $receipt->created_by }}</td>
                                            @php
                                                $counter++;
                                            @endphp
                                        </tr>
                                    @endforeach
                                @endforeach
                            @endforeach
                        </tbody>
                        <tfoot>
                            <tr>
                                <th class="wd-10p">#</th>
                                <th class="wd-10p">Date</th>
                                <th class="wd-10p">P. No</th>
                                <th class="wd-10p">Truck No</th>
                                <th class="wd-10p">Products Name</th>
                                <th class="wd-10p">Marka</th>
                                <th class="wd-10p">Overall Bori</th>
                                <th class="wd-10p">Remaining Bori</th>
                                {{-- <th class="wd-10p">Sold</th> --}}
                                <th class="wd-10p">Weight</th>
                                <th class="wd-10p">Rate</th>
                                <th class="wd-10p">Builty No</th>
                                <th class="none">Supplier</th>
                                <th class="none">Remarks</th>
                                <th class="none">Created By</th>
                                {{-- <th>Actions</th> --}}
                            </tr>
                        </tfoot>
                    </table>

                </div>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="deleteModalLabel">Confirm Deletion</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this Product?
                </div>
                <div class="modal-footer">
                    <form id="deleteForm" action="" method="POST">
                        @csrf
                        @method('GET')
                        <button type="button" class="btn btn-secondary text-light" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-danger">Delete</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('scripts')
    <script type="text/javascript">
        $(document).ready(function() {

            $('#example2 tfoot th').each(function() {
                var title = $(this).text();
                $(this).html('<input type="text" class="form-control" placeholder="' + title + '" />');
            });

            $('#example2').DataTable({
                "ordering": true,
                "dom": 'Blfrtip',
                "buttons": [
                    'excel', 'pdf', 'print'
                ],
                responsive: !0,
                columnDefs: [{
                    className: 'control',
                    orderable: false,
                    targets: 0
                }],
                initComplete: function() {
                    // Apply the search
                    this.api()
                        .columns()
                        .every(function() {
                            var that = this;

                            $('input', this.footer()).on('keyup change clear', function() {
                                if (that.search() !== this.value) {
                                    that.search(this.value).draw();
                                }
                            });
                        });
                }
            });
        });

        $(document).ready(function() {
            $('#deleteModal').on('show.bs.modal', function(event) {
                var button = $(event.relatedTarget);
                var id = button.data('id');
                var actionUrl = '{{ url('good_receipts/destroy') }}/' + id;
                var modal = $(this);
                modal.find('#deleteForm').attr('action', actionUrl);
            });
        });
    </script>
@endpush
